/**
 * \file: base64.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * \component: Secure Data Container
 *
 * \author: Ian Molton (ian.molton@codethink.co.uk)
 *	   Norbert Uetrecht (nuetrecht@de.adit-jv.com)
 *
 * \copyright (c) 2014 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 *
 ***********************************************************************/

#ifndef __LIBKEYMAN_BASE64_H_
#define __LIBKEYMAN_BASE64_H_


#include <stdint.h>


/* length without additional \0 */
#define B64_ENC_LEN(len) (((len + 2) / 3) * 4)

/**
 * Find required buffer length for decoding Base64 encoded data
 *
 * \param bufcoded		Buffer to be decoded
 * \return required buffer length
 */
int base64_decode_len(const uint8_t *bufcoded);

/**
 * Decode '/0' terminated Base64 data
 *
 * \param out	Updated to decoded output, caller allocates space
 * \param enc	Base64 encoded data, '\0' terminated
 * \return number of bytes written to output
 */
int base64_decode(uint8_t *out, const uint8_t *enc);

/**
 * Find required buffer length to Base64 encode data of length len
 *
 * \param len		Byte length of to be encoded
 * \return required buffer length
 */
int base64_encode_len(int len);

/**
 * Base64 encode a data of length len
 *
 * \param out	Updated to Base64 encoded output, caller allocates space
 * \param data	Data to Base64 encode
 * \param len	Byte length of data to encode
 * \return number of bytes written to output
 */
int base64_encode(uint8_t *out, const uint8_t *data, int len);

#endif

